import Foundation

/// Simple service to manage medical disclaimer acceptance
class DisclaimerService: ObservableObject {
    @Published var hasAcceptedDisclaimer: Bool = false
    
    private let userDefaults = UserDefaults.standard
    private let disclaimerKey = "hasAcceptedMedicalDisclaimer"
    
    init() {
        hasAcceptedDisclaimer = userDefaults.bool(forKey: disclaimerKey)
    }
    
    func acceptDisclaimer() {
        hasAcceptedDisclaimer = true
        userDefaults.set(true, forKey: disclaimerKey)
    }
    
    func resetDisclaimer() {
        hasAcceptedDisclaimer = false
        userDefaults.removeObject(forKey: disclaimerKey)
    }
}